<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

// Turn off error reporting so that if anything goes wrong, your visitor won't know the difference.
//error_reporting(0);

/*
Declare these two important variables.
The script will perform various tests and determine if it should show ads for the visitor.
If the visitor fails any of the tests done in this file, the script will say it shouldn't
show ads and it will stop performing any subsequent tests.
*/
$test_done = false;
$show_ads = true;

// Find out where this file is on the server so that we access the configuration files
$adlogger_file_path = str_replace('track/ad_check.php', '', __FILE__);

// Include the configuration files to connect to the database and find the current settings
require ("$adlogger_file_path" . "config_database.php");
require ("$adlogger_file_path" . "config_settings.php");

// Include the functions file where the all the functions are defined
require ("$adlogger_file_path" . "track/functions/functions.php");

// Declare the visitor's IP address
$visitor_ip = visitorIP();

/*
Step 1:
See if the ads are disabled for EVERYONE.
This value is set on the Settings page and stored in config_settings.php
*/
if ($disable_all_ads) {
	$show_ads = false;
	$test_done = true;
	$reason = 1;
}

/*
Step 2:
Check to see if the IP address is banned from seeing ads.
This takes the banned array from config_settings.php, cycles through it, and
determines if the IP address meets any of the criteria for not showing ads:
(a) the IP is banned directly, or (b) the IP address range is banned.
*/
if (!$test_done) {
	foreach ($ip_range_ban_list as $ip_range_ban) {
		if ((ban_ip_range($visitor_ip, $ip_range_ban)) && (!empty($ip_range_ban))) {
			$show_ads = false;
			$test_done = true;
			$reason = 2;
			break;
		}
	}
}

/*
Step 3:
Check in the database to see if the this visitor's IP address has clicked any ads recently.
It only performs this test if the setting to do so is "Yes" on the Settings page.
You can optionally skip this step if you don't want to peform this query.

IF statement translation:
"If (a)the user still has to go through this test, and (b)you want to check his IP against the database,
and (c)the script has successfully established a connection to the database, ..."
*/
if (!$test_done && $ip_db_check && $adlogger_db_connect && $adlogger_db_select) {
	// Determine how far back in the logs to check
	$backlog_timeframe = $timestamp - $clickmaxtime;

	// Perform the query
	$result = mysql_query("SELECT COUNT(visitor_ip) FROM " . $db_table_prefix . "adcheck_logs WHERE visitor_ip = '$visitor_ip' AND timestamp > '$backlog_timeframe'");
		$row = mysql_fetch_array($result);

			// How many results were there?
			$visitors_recent_clicks = $row['COUNT(visitor_ip)'];

			// If the results are greater than or equal to the maximum number of allowed clicks, don't show ads.
			if ($visitors_recent_clicks >= $clickmax) {
				$show_ads = false;
				$test_done = true;
				$reason = 3;
			}
}

/*
Step 4:
If ads are indeed blocked for this visitor, log it in the blocked logs table in the database.
It will tell who, when, and why.
*/
if (!$show_ads) {
	$blocked_url = get_disp_page($_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
	mysql_query("INSERT INTO " . $db_table_prefix . "blocklogs SET
		timestamp='$timestamp',
		visitor_ip='$visitor_ip',
		reason='$reason',
		blocked_url='$blocked_url'
	");
}

// Set a cookie so we know how this person got to your site
if (!isset($_SESSION['adlog_ref']) || empty($_SESSION['adlog_ref'])) {
	$_SESSION['adlog_ref'] = $_SERVER['HTTP_REFERER'];
}

/*
After performing those tests, if the visitor hasn't failed any of them, the $show_ads variable
should still be set to TRUE, allowing them to view the ads on the page.
*/
//echo $_COOKIE['adlog_ref'];
?>